#version 330
#extension GL_EXT_gpu_shader4 : enable
//raymarched tunnelMod01.fsh  by  isk
//https://www.shadertoy.com/view/WtVSRV
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const int ITER=256;
const float MAX=100.,EPS=.001;

vec3 ray(vec2 uv, vec3 ro, vec3 poi) {
    vec3 f=normalize(poi-ro),
         r=normalize(cross(vec3(0,1,0),f)),
         u=cross(f,r),
         m=ro+f,
         p=m+r*uv.x+u*uv.y;
    return normalize(p-ro);
}

float zcyl(vec3 p, float r) {
    return length(p.xy)-r;
}

float scene(vec3 p) {
    return .5-zcyl(p,.5);
}

float map(vec3 ro, vec3 rd) {
    float t=0.,d;
    for(int i=0; i<ITER; ++i) {
        d=scene(ro+rd*t);
        if(abs(d)<EPS) return t;
        t+=d;
        if(t>MAX) return t;
    }
    return t;
}

vec3 normal(vec3 p) {
    const vec2 D=vec2(.001,0);
    return normalize(scene(p)-vec3(scene(p-D.xyy),scene(p-D.yxy),scene(p-D.yyx)));
}

vec3 march(vec2 uv) {
    vec3 ro=vec3(sin(iTime)/2.,sin(iTime*.8)*.2,cos(iTime)/2.),rd=ray(uv,ro,vec3(0));
    
    float t=map(ro, rd);
    
    if (t<MAX) {
        vec3 p=ro+rd*t;
        vec3 n=normal(p);
        vec2 uv=vec2(p.z,atan(p.y,p.x));
        vec3 tex=texture2D(iChannel0,uv-vec2(iTime,.0)).rgb;
        return tex/max(abs(-p.z),1.);
    }
    
    return vec3(0);
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 gl_FragCoord.xy)
 {
    vec2 uv=(gl_FragCoord.xy -.5*iResolution.xy)/iResolution.y;
    vec3 col=march(uv);
    gl_FragColor=vec4(col,1);
}